# sensor-control

This provides the core sensor functionality (other than acoustic and visual) for WildlifeSystems nodes. A default sensing device, `onboard` is provided which provides useful diagnostic information about the Raspberry Pi.

## Installing the software

[Add the WildlifeSystems APT repository to your system](https://wildlife.systems/apt-configuration.html)

Install sensor-control.

```bash
sudo apt update
sudo apt install sensor-control
```


## sr: sensor read

The `sr` command reads sensors and outputs their data as JSON. It runs multiple sensors in parallel for efficiency.

To read a specific sensor use `sr <device> <sensor>`, e.g. to read the onboard CPU temperature run:

```bash
sr onboard onboard_cpu
```

To read all sensors from a device:

```bash
sr onboard all
```

To list all installed sensor devices:

```bash
sr list
```

### Concurrency Control

By default, `sr` runs sensors in parallel using a concurrency limit based on your CPU count (minimum 4). You can override this with the `CONCURRENCY` environment variable:

```bash
# Run up to 8 sensors concurrently
CONCURRENCY=8 sr all

# Run sensors sequentially (one at a time)
CONCURRENCY=1 sr all
```

### sr output

`sr` provides an array of JSON objects that each describe the sensor and measurement.

| key           | value |
|---------------|-------|
| sensor        | Short name of the sensor (no whitespace) |
| measures      | The property being measured (e.g. temperature) |
| value         | The value currently measured by the sensor |
| unit          | The unit of measurement of value |
| node_id       | The serial number of the node |
| sensor_id     | Serial number of sensor (if available) |
| timestamp     | Timestamp of when the sensor was read |
| config        | (Optional) Additional configuration details about the sensor. May be JSON array. |
| internal      | (Optional) Boolean flag indicating if sensor is for internal monitoring |

### Return Codes

`sr` uses standard return codes:

| Code | Meaning |
|------|---------|
| 0    | Success |
| 1    | Missing required commands or system error |
| 2    | Invalid arguments or sensor name |
| 20   | Unknown device |
| 21   | Unknown sensor or sensor not found |

## Installing a new sensing device

To install a new sensing device that already has been integrated into WildlifeSystems, use the `sc-inst` script. This will install the sensing device and any dependencies it may have.

```
sc-inst <device>
```

## Adding a new sensing device

New sensing devices should be added as separate scripts/programs that take the prototype JSON response generated by `sc-prototype` and populate the values `sensor`, `measures`, `value`, `unit` and, where appropriate, `config`. The modified JSON should then be printed to `stdout`.

The fields `node_id` and `timestamp` are populated by the sensor read command, `sr`.

The `sensor-onboard` script installed with this package provides a reference implementation in bash using the `jq` command to process JSON.

### Sensor Script Requirements

1. **Executable**: Must be executable and named `sensor-<devicename>` in `/usr/bin/`
2. **Identify command**: Must exit with code 60 when called with `identify` argument
3. **List command**: Must list available sensors when called with `list` argument
4. **JSON output**: Must output valid JSON array to stdout
5. **Error handling**: Use exit code 21 for unknown sensors, 20 for unknown devices
6. **Timeout**: Scripts should complete within 5 seconds (enforced by `sr`)

There are no restrictions on the scripting/programming language(s) that may be used, however it should be kept in mind that the scripts will likely be running on connected, autonomous nodes. For this reason it is recommended that minimizing the installation of additional packages, and the number of scripting environments overall, should be priorities (there is a reason that `sensor-onboard` is written in bash).

## Development

- Development of this script was done as part of the Urban Nature Project at the Natural History Museum, London.
